
import gurobi

def solve_factory_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="soccer_balls", lb=0, ub=None)
    x2 = model.addVar(name="basket_balls", lb=0, ub=None)

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(5 * x1 + 7 * x2 <= 700, name="manufacturing_machine_time")
    model.addConstr(3 * x1 + 4 * x2 <= 500, name="air_filling_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: soccer balls = {x1.varValue}, basket balls = {x2.varValue}")
        print(f"Maximum profit: ${4 * x1.varValue + 5 * x2.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_factory_problem()
