
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("jewelry_optimization")

# Create variables
sapphire_rings = m.addVar(vtype=GRB.INTEGER, name="sapphire_rings")
ruby_rings = m.addVar(vtype=GRB.INTEGER, name="ruby_rings")

# Set objective function
m.setObjective(500 * sapphire_rings + 400 * ruby_rings, GRB.MAXIMIZE)

# Add constraints
m.addConstr(sapphire_rings <= 10, "sapphire_production_limit")
m.addConstr(ruby_rings <= 15, "ruby_production_limit")
m.addConstr(sapphire_rings + ruby_rings <= 15, "master_jeweler_limit")
m.addConstr(sapphire_rings >=0)
m.addConstr(ruby_rings >=0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of sapphire rings to make: {sapphire_rings.x}")
    print(f"Number of ruby rings to make: {ruby_rings.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

