
from gurobipy import *

# Create a new model
m = Model("Jewelry_Company_Profit")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sapphire_rings")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ruby_rings")

# Set the objective function
m.setObjective(500*x1 + 400*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 10, "sapphire_limit")
m.addConstr(x2 <= 15, "ruby_limit")
m.addConstr(x1 + x2 <= 15, "jeweler_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of sapphire rings: {x1.x}")
    print(f"Number of ruby rings: {x2.x}")
    print(f"Maximum profit: ${500*x1.x + 400*x2.x:.2f}")
else:
    print("No optimal solution found.")
