
import gurobipy as gp

# Create a new model
model = gp.Model("Sapphire_Ruby_Rings")

# Define variables
x1 = model.addVar(name="sapphire_rings", lb=0, ub=10, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="ruby_rings", lb=0, ub=15, vtype=gp.GRB.INTEGER)

# Set objective function
model.setObjective(500*x1 + 400*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 10, name="sapphire_team_limit")
model.addConstr(x2 <= 15, name="ruby_team_limit")
model.addConstr(x1 + x2 <= 15, name="master_jeweler_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Sapphire rings: {x1.varValue}")
    print(f"Ruby rings: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
