
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("jewelry_production")

# Create decision variables
earrings = model.addVar(vtype=GRB.CONTINUOUS, name="earrings")
watches = model.addVar(vtype=GRB.CONTINUOUS, name="watches")


# Set objective function
model.setObjective(45 * earrings + 70 * watches, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * earrings + 3.5 * watches <= 14, "heating_constraint")
model.addConstr(1.5 * earrings + 2 * watches <= 10, "polishing_constraint")
model.addConstr(earrings >= 0, "earrings_nonnegative")
model.addConstr(watches >= 0, "watches_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of earrings to produce: {earrings.x:.2f}")
    print(f"Number of watches to produce: {watches.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

