
from gurobipy import *

# Create a new model
m = Model("Gem_Store_Profit")

# Add variables
x1 = m.addVar(lb=0, name="pairs_of_earrings")
x2 = m.addVar(lb=0, name="watches")

# Set the objective function
m.setObjective(45*x1 + 70*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 3.5*x2 <= 14, "heating_machine")
m.addConstr(1.5*x1 + 2*x2 <= 10, "polishing_machine")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
