
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="earrings", lb=0)
x2 = m.addVar(name="watches", lb=0)

# Define the objective function
m.setObjective(45 * x1 + 70 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(2 * x1 + 3.5 * x2 <= 14, name="heating_machine")
m.addConstr(1.5 * x1 + 2 * x2 <= 10, name="polishing_machine")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Pairs of earrings: {x1.varValue}")
    print(f"Watches: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found")
