
import gurobipy as gp

# Create a new model
m = gp.Model("Juice Production")

# Create variables
juice_a = m.addVar(vtype=gp.GRB.CONTINUOUS, name="juice_a")  # Number of Juice A
juice_b = m.addVar(vtype=gp.GRB.CONTINUOUS, name="juice_b")  # Number of Juice B


# Set objective function
m.setObjective(5 * juice_a + 7 * juice_b, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * juice_a + 15 * juice_b <= 2000, "raspberries_constraint")
m.addConstr(10 * juice_a + 15 * juice_b <= 1500, "blueberries_constraint")
m.addConstr(10 * juice_a + 5 * juice_b <= 1400, "blackberries_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Juice A to produce: {juice_a.x}")
    print(f"Number of Juice B to produce: {juice_b.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

