
from gurobipy import *

# Create a new model
m = Model("Juice_Production")

# Define variables
x1 = m.addVar(name="Juice_A", lb=0)
x2 = m.addVar(name="Juice_B", lb=0)

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 2000, name="Raspberries")
m.addConstr(10*x1 + 15*x2 <= 1500, name="Blueberries")
m.addConstr(10*x1 + 5*x2 <= 1400, name="Blackberries")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Juice A: {x1.x}")
    print(f"Juice B: {x2.x}")
    print(f"Total Profit: ${5*x1.x + 7*x2.x:.2f}")
else:
    print("No optimal solution found")
