
import gurobipy as gp

# Create a new model
m = gp.Model("Juice_Optimization")

# Define the variables
x1 = m.addVar(name="Juice_A", lb=0)  # Number of Juice A
x2 = m.addVar(name="Juice_B", lb=0)  # Number of Juice B

# Define the objective function
m.setObjective(5 * x1 + 7 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(20 * x1 + 15 * x2 <= 2000, name="Raspberries_Constraint")
m.addConstr(10 * x1 + 15 * x2 <= 1500, name="Blueberries_Constraint")
m.addConstr(10 * x1 + 5 * x2 <= 1400, name="Blackberries_Constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Juice A: {x1.varValue}")
    print(f"Number of Juice B: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
