
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("BurritoOptimization")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Mexican_burrito")  # Number of Mexican burritos
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Korean_burrito")  # Number of Korean burritos


# Set objective function
m.setObjective(7*x1 + 4.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 5*x2 <= 70, "Cheese_constraint")
m.addConstr(8*x1 <= 60, "Beans_constraint")
m.addConstr(5*x2 <= 45, "Onions_constraint")
m.addConstr(x1 >= 0, "Non_negativity_x1")
m.addConstr(x2 >= 0, "Non_negativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of Mexican burritos: {x1.x:.2f}")
    print(f"Number of Korean burritos: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

