
from gurobipy import *

# Create a new model
model = Model("Burrito_Optimization")

# Add variables
x1 = model.addVar(lb=0, name="Mexican_Burritos")
x2 = model.addVar(lb=0, name="Korean_Burritos")

# Set the objective function
model.setObjective(7*x1 + 4.5*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7*x1 + 5*x2 <= 70, "Cheese_Constraint")
model.addConstr(8*x1 <= 60, "Beans_Constraint")
model.addConstr(5*x2 <= 45, "Onions_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Mexican burritos: {x1.x}")
    print(f"Number of Korean burritos: {x2.x}")
    print(f"Total profit: ${7*x1.x + 4.5*x2.x:.2f}")
else:
    print("No optimal solution found")
