
import gurobipy as gp

# Create a new model
model = gp.Model("Burrito_Production")

# Define variables
x1 = model.addVar(name="Mexican_burritos", lb=0, ub=None, obj=7)
x2 = model.addVar(name="Korean_burritos", lb=0, ub=None, obj=4.5)

# Add constraints
model.addConstr(7 * x1 + 5 * x2 <= 70, name="Cheese_Constraint")
model.addConstr(8 * x1 <= 60, name="Beans_Constraint")
model.addConstr(5 * x2 <= 45, name="Onions_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of Mexican burritos: {x1.varValue}")
    print(f"Number of Korean burritos: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible.")
