
import gurobipy as gp

# Create a new model
m = gp.Model("tech_company_production")

# Create variables
laptops = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laptops")
tablets = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tablets")


# Set objective function
m.setObjective(200 * laptops + 160 * tablets, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * laptops + 15 * tablets <= 1200, "manufacturing_time")
m.addConstr(3 * laptops + 2 * tablets <= 150, "silicon")
m.addConstr(laptops >= 30, "min_laptops")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of laptops to produce: {laptops.x}")
    print(f"Number of tablets to produce: {tablets.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

