
from gurobipy import *

# Create a new model
m = Model("Laptop_Tablet_Production")

# Define variables
x1 = m.addVar(name="laptops", vtype=GRB.INTEGER)
x2 = m.addVar(name="tablets", vtype=GRB.INTEGER)

# Set objective function
m.setObjective(200*x1 + 160*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 1200, name="manufacturing_time")
m.addConstr(x1 >= 30, name="minimum_laptops")
m.addConstr(3*x1 + 2*x2 <= 150, name="silicon_availability")
m.addConstr(x1 >= 0, name="non_negative_laptops")
m.addConstr(x2 >= 0, name="non_negative_tablets")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum Profit: ${200*x1.x + 160*x2.x}")
else:
    print("No optimal solution found")
