
import gurobipy as gp

# Create a new model
model = gp.Model("Laptop_Tablet_Production")

# Define the variables
x1 = model.addVar(name="laptops", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="tablets", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: maximize profit
model.setObjective(200*x1 + 160*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 30, name="min_laptops")
model.addConstr(20*x1 + 15*x2 <= 1200, name="manufacturing_time")
model.addConstr(3*x1 + 2*x2 <= 150, name="silicon_availability")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
