
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flower_Profit")

# Create variables
daisies = m.addVar(lb=0, name="daisies")  # Acres of daisies
peonies = m.addVar(lb=0, name="peonies")  # Acres of peonies


# Set objective function: Maximize profit
m.setObjective(150 * daisies + 180 * peonies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(daisies + peonies <= 55, "Land_Constraint")  # Total land constraint
m.addConstr(4.5 * daisies + 7 * peonies <= 200, "Nutrition_Constraint")  # Plant nutrition constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Daisies: {daisies.x}")
    print(f"Acres of Peonies: {peonies.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

