
from gurobipy import *

# Create a new model
m = Model("Hudson_Flower_Problem")

# Add variables
x1 = m.addVar(lb=0, name="daisies")
x2 = m.addVar(lb=0, name="peonies")

# Set the objective function
m.setObjective(150*x1 + 180*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 55, name="total_land")
m.addConstr(4.5*x1 + 7*x2 <= 200, name="plant_nutrition")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
