
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="daisies")
    x2 = model.addVar(lb=0, name="peonies")

    # Objective function
    model.setObjective(150*x1 + 180*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 55, name="total_acres")
    model.addConstr(4.5*x1 + 7*x2 <= 200, name="plant_nutrition")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of daisies: {x1.varValue}")
        print(f"Acres of peonies: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
