
import gurobipy as gp

# Create a new model
m = gp.Model("kitchen_optimization")

# Create variables
plates = m.addVar(vtype=gp.GRB.INTEGER, name="plates")
forks = m.addVar(vtype=gp.GRB.INTEGER, name="forks")

# Set objective function
m.setObjective(10 * plates + 8 * forks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * plates + 20 * forks <= 5000, "woodworker_time")
m.addConstr(forks >= 2 * plates, "fork_demand")
m.addConstr(plates >= 0, "plates_nonnegative")  # Explicit non-negativity constraints
m.addConstr(forks >= 0, "forks_nonnegative")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of plates: {plates.x}")
    print(f"Number of forks: {forks.x}")

