
from gurobipy import *

# Create a model
m = Model("Artisan_Kitchen")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="plates")
x2 = m.addVar(vtype=GRB.INTEGER, name="forks")

# Set the objective function
m.setObjective(10*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 20*x2 <= 5000, "time_constraint")
m.addConstr(x2 >= 2*x1, "demand_constraint")
m.addConstr(x1 >= 0, "non_neg_plates")
m.addConstr(x2 >= 0, "non_neg_forks")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Plates: {x1.x}")
    print(f"Forks: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
