
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="plates", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="forks", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(10*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(30*x1 + 20*x2 <= 5000, name="woodworker_time")
    model.addConstr(x2 >= 2*x1, name="fork_to_plate_ratio")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of plates: {x1.varValue}")
        print(f"Optimal number of forks: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
