
import gurobipy as gp

# Create a new model
m = gp.Model("food_truck")

# Create variables
shrimp = m.addVar(lb=0, name="shrimp")  # kg of shrimp
beef = m.addVar(lb=0, name="beef")  # kg of beef


# Set objective function: Minimize cost
m.setObjective(36 * shrimp + 40 * beef, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.5 * shrimp + 4 * beef >= 20, "protein_req")  # Protein requirement
m.addConstr(3 * shrimp + 2.5 * beef >= 25, "fat_req")  # Fat requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Shrimp: {shrimp.x:.2f} kg")
    print(f"Beef: {beef.x:.2f} kg")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

