
from gurobipy import *

# Create a new model
m = Model("FoodTruck")

# Define variables
x1 = m.addVar(lb=0, name="shrimp")
x2 = m.addVar(lb=0, name="beef")

# Set the objective function
m.setObjective(36*x1 + 40*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.5*x1 + 4*x2 >= 20, "protein_constraint")
m.addConstr(3*x1 + 2.5*x2 >= 25, "fat_constraint")

# Optimize model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shrimp: {x1.x} kg")
    print(f"Beef: {x2.x} kg")
    print(f"Total cost: ${36*x1.x + 40*x2.x}")
else:
    print("No optimal solution found.")
