
import gurobi

def solve_sausage_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="shrimp", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="beef", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(36 * x1 + 40 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2.5 * x1 + 4 * x2 >= 20, name="protein_constraint")
    model.addConstr(3 * x1 + 2.5 * x2 >= 25, name="fat_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal cost: ", model.objVal)
        print("Shrimp (kg): ", x1.x)
        print("Beef (kg): ", x2.x)
    else:
        print("The problem is infeasible")

solve_sausage_problem()
