
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("chair_production")

# Create variables
leather_chairs = m.addVar(vtype=GRB.INTEGER, name="leather_chairs")
mesh_chairs = m.addVar(vtype=GRB.INTEGER, name="mesh_chairs")

# Set objective function
m.setObjective(150 * leather_chairs + 100 * mesh_chairs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(leather_chairs <= 20, "leather_chair_production_limit")
m.addConstr(mesh_chairs <= 30, "mesh_chair_production_limit")
m.addConstr(leather_chairs + mesh_chairs <= 30, "quality_check_limit")
m.addConstr(leather_chairs >=0)
m.addConstr(mesh_chairs >=0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of leather chairs to produce: {leather_chairs.x}")
    print(f"Number of mesh chairs to produce: {mesh_chairs.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

