
from gurobipy import *

# Create a new model
m = Model("Office_Chair_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="leather_chairs")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mesh_chairs")

# Set the objective function
m.setObjective(150*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 20, "Team_A_Capacity")
m.addConstr(x2 <= 30, "Team_B_Capacity")
m.addConstr(x1 + x2 <= 30, "Quality_Check_Capacity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Leather Chairs: {x1.x}")
    print(f"Mesh Chairs: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
