
import gurobipy as gp

# Create a new model
model = gp.Model("OfficeChairProduction")

# Define the variables
x1 = model.addVar(name="leather_chairs", lb=0, ub=20, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="mesh_chairs", lb=0, ub=30, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(150 * x1 + 100 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 20, name="leather_chairs_limit")
model.addConstr(x2 <= 30, name="mesh_chairs_limit")
model.addConstr(x1 + x2 <= 30, name="quality_check_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.x[0].varName} = {model.x[0].x}, {model.x[1].varName} = {model.x[1].x}")
    print(f"Max Profit: ${150*model.x[0].x + 100*model.x[1].x:.2f}")
else:
    print("No optimal solution found.")
