
import gurobipy as gp

# Create a new model
m = gp.Model("kitchen_problem")

# Create variables
spoons = m.addVar(vtype=gp.GRB.CONTINUOUS, name="spoons")
forks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="forks")
knives = m.addVar(vtype=gp.GRB.CONTINUOUS, name="knives")


# Set objective function
m.setObjective(2 * spoons + 3 * forks + 4 * knives, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * spoons + 1.5 * forks + 2 * knives <= 400, "steel_constraint")
m.addConstr(2 * spoons + 1.5 * forks + 1 * knives <= 500, "rubber_constraint")
m.addConstr(spoons >=0)
m.addConstr(forks >=0)
m.addConstr(knives >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal revenue: {m.objVal}")
    print(f"Number of spoons: {spoons.x}")
    print(f"Number of forks: {forks.x}")
    print(f"Number of knives: {knives.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

