
from gurobipy import *

# Create a model
m = Model("Kitchen_Company")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="spoons")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="forks")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="knives")

# Set objective function
m.setObjective(2*x1 + 3*x2 + 4*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 1.5*x2 + 2*x3 <= 400, "steel_constraint")
m.addConstr(2*x1 + 1.5*x2 + x3 <= 500, "rubber_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Spoons: {x1.x}")
    print(f"Forks: {x2.x}")
    print(f"Knives: {x3.x}")
else:
    print("No optimal solution found")
