
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="spoons", lb=0, ub=float('inf'), obj=2)
    x2 = model.addVar(name="forks", lb=0, ub=float('inf'), obj=3)
    x3 = model.addVar(name="knives", lb=0, ub=float('inf'), obj=4)

    # Add constraints
    model.addConstr(x1 + 1.5 * x2 + 2 * x3 <= 400, name="steel_constraint")
    model.addConstr(2 * x1 + 1.5 * x2 + x3 <= 500, name="rubber_constraint")

    # Set the objective function
    model.setObjective(x1.obj * x1.varName + x2.obj * x2.varName + x3.obj * x3.varName, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Spoons: {x1.x}")
        print(f"Forks: {x2.x}")
        print(f"Knives: {x3.x}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
