
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Sandwich_A") # Number of Sandwich A
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Sandwich_B") # Number of Sandwich B


# Set objective function
model.setObjective(5*x1 + 6*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x1 + 5*x2 <= 500, "cheddar_constraint")
model.addConstr(3*x1 + 2*x2 <= 400, "american_constraint")
model.addConstr(x1 >= 0, "non_negativity_A")
model.addConstr(x2 >= 0, "non_negativity_B")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Sandwich A: {x1.x}")
    print(f"Number of Sandwich B: {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

