
from gurobipy import *

# Create a new model
m = Model("Sandwich_Optimization")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Sandwich_A", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Sandwich_B", lb=0)

# Set the objective function
m.setObjective(5*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 500, "Cheddar_Cheese_Constraint")
m.addConstr(3*x1 + 2*x2 <= 400, "American_Cheese_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Sandwich A: {x1.x}")
    print(f"Number of Sandwich B: {x2.x}")
    print(f"Maximum Profit: ${5*x1.x + 6*x2.x:.2f}")
else:
    print("No optimal solution found.")
