
import gurobi

def solve_sandwich_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Sandwich_A", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="Sandwich_B", lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(5 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 5 * x2 <= 500, name="cheddar_constraint")
    model.addConstr(3 * x1 + 2 * x2 <= 400, name="american_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Sandwich A = {x1.varValue}, Sandwich B = {x2.varValue}")
        print(f"Maximum profit: ${5 * x1.varValue + 6 * x2.varValue}")
    else:
        print("No optimal solution found")

solve_sandwich_problem()
