
from gurobipy import *

# Create a new model
m = Model("Hotel_Staffing")

# Define variables
x1 = m.addVar(name='cleaners', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='receptionists', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(500*x1 + 350*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 100, name='total_workers')
m.addConstr(x2 >= 20, name='min_receptionists')
m.addConstr(x2 >= (1/3)*x1, name='receptionist_to_cleaner_ratio')
m.addConstr(500*x1 + 350*x2 <= 30000, name='max_wage_bill')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Minimum wage bill: {m.objVal}")
    print(f"Number of cleaners: {x1.x}")
    print(f"Number of receptionists: {x2.x}")
else:
    print("Model is infeasible")
