
import gurobi

def hotel_staffing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='cleaners', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of cleaners
    x2 = model.addVar(name='receptionists', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of receptionists

    # Objective function: Minimize the wage bill
    model.setObjective(500*x1 + 350*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 100, name='min_workers')
    model.addConstr(x2 >= 20, name='min_receptionists')
    model.addConstr(x2 >= (1/3)*x1, name='receptionists_to_cleaners_ratio')
    model.addConstr(500*x1 + 350*x2 <= 30000, name='wage_bill')

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of cleaners: {x1.varValue}")
        print(f"Optimal number of receptionists: {x2.varValue}")
        print(f"Minimum wage bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

hotel_staffing_problem()
