
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cruise_ship_profit")

# Create variables
luxury_tickets = m.addVar(vtype=GRB.INTEGER, name="luxury_tickets")
regular_tickets = m.addVar(vtype=GRB.INTEGER, name="regular_tickets")

# Set objective function
m.setObjective(500 * luxury_tickets + 300 * regular_tickets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(luxury_tickets + regular_tickets <= 500, "total_passengers")
m.addConstr(luxury_tickets >= 100, "min_luxury_tickets")
m.addConstr(regular_tickets >= 2 * luxury_tickets, "regular_vs_luxury")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution and objective value
    print("Optimal Solution:")
    print(f"Luxury Tickets: {luxury_tickets.x}")
    print(f"Regular Tickets: {regular_tickets.x}")
    print(f"Maximum Profit: ${m.objVal}")

