
from gurobipy import *

# Create a new model
m = Model("Cruise_Ticket_Sales")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="luxury_tickets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")

# Set the objective function
m.setObjective(500*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, "total_passengers")
m.addConstr(x1 >= 100, "min_luxury_tickets")
m.addConstr(x2 >= 2*x1, "regular_vs_luxury")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Luxury tickets: {x1.x}")
    print(f"Regular tickets: {x2.x}")
    print(f"Total profit: ${500*x1.x + 300*x2.x}")
else:
    print("No optimal solution found.")
