
import gurobi

def solve_cruise_ship_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="luxury_tickets")
    x2 = model.addVar(lb=0, name="regular_tickets")

    # Set the objective function
    model.setObjective(500 * x1 + 300 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 500, name="total_passengers")
    model.addConstr(x1 >= 100, name="min_luxury_tickets")
    model.addConstr(x2 >= 2 * x1, name="regular_to_luxury_ratio")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of luxury tickets: {x1.varValue}")
        print(f"Number of regular tickets: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_cruise_ship_problem()
