
import gurobipy as gp

# Create a new model
m = gp.Model("ice_cream_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberry_cakes") #strawberry cakes
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mint_cakes") # mint cakes


# Set objective function
m.setObjective(2.5 * x1 + 4 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 10, "strawberry_min")
m.addConstr(x1 <= 20, "strawberry_max")
m.addConstr(x2 >= 20, "mint_min")
m.addConstr(x2 <= 40, "mint_max")
m.addConstr(x1 + x2 <= 50, "total_cakes")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of strawberry cakes: {x1.x}")
    print(f"Number of mint cakes: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

