
from gurobipy import *

# Create a new model
m = Model("IceCreamCakes")

# Define variables
x1 = m.addVar(lb=10, ub=20, vtype=GRB.INTEGER, name="strawberry")
x2 = m.addVar(lb=20, ub=40, vtype=GRB.INTEGER, name="mint")

# Set the objective function
m.setObjective(2.5*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 50, "total_cakes")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strawberry ice cream cakes: {x1.x}")
    print(f"Mint ice cream cakes: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
