
import gurobipy as gp

# Create a new model
model = gp.Model("IceCreamOptimization")

# Define variables
x1 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="strawberry_ice_cream_cakes")
x2 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="mint_ice_cream_cakes")

# Set bounds according to the problem description
x1.lb = 10
x1.ub = 20
x2.lb = 20
x2.ub = 40

# Objective function: Maximize 2.5*x1 + 4*x2
model.setObjective(2.5 * x1 + 4 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 10, name="strawberry_min")
model.addConstr(x1 <= 20, name="strawberry_max")
model.addConstr(x2 >= 20, name="mint_min")
model.addConstr(x2 <= 40, name="mint_max")
model.addConstr(x1 + x2 <= 50, name="total_cakes")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: strawberry ice cream cakes = {x1.varValue}, mint ice cream cakes = {x2.varValue}")
    print(f"Maximum profit: ${2.5 * x1.varValue + 4 * x2.varValue:.2f}")
else:
    print("No optimal solution found.")
