
import gurobipy as gp

# Create a new model
m = gp.Model("cookie_optimization")

# Create variables
chocolate_cookies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate_cookies")
strawberry_cookies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberry_cookies")


# Set objective function
m.setObjective(1.5 * chocolate_cookies + 1.2 * strawberry_cookies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(chocolate_cookies + strawberry_cookies <= 200, "total_cookies")
m.addConstr(chocolate_cookies >= 50, "min_chocolate")
m.addConstr(strawberry_cookies >= 70, "min_strawberry")
m.addConstr(chocolate_cookies <= 120, "max_chocolate")
m.addConstr(strawberry_cookies <= 150, "max_strawberry")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of chocolate cookies: {chocolate_cookies.x}")
    print(f"Number of strawberry cookies: {strawberry_cookies.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

