
from gurobipy import *

# Create a new model
m = Model("Cookie_Optimization")

# Add variables
x1 = m.addVar(lb=50, ub=120, vtype=GRB.CONTINUOUS, name="chocolate_cookies")
x2 = m.addVar(lb=70, ub=150, vtype=GRB.CONTINUOUS, name="strawberry_cookies")

# Set the objective function
m.setObjective(1.5*x1 + 1.2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, "total_cookies")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Cookies: {x1.x}")
    print(f"Strawberry Cookies: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
