
import gurobi

def solve_cookie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=200, name="chocolate_cookies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, ub=200, name="strawberry_cookies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.5 * x1 + 1.2 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 200, name="total_cookies")
    model.addConstr(x1 >= 50, name="min_chocolate_cookies")
    model.addConstr(x2 >= 70, name="min_strawberry_cookies")
    model.addConstr(x1 <= 120, name="max_chocolate_cookies")
    model.addConstr(x2 <= 150, name="max_strawberry_cookies")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Chocolate Cookies: {x1.varValue}")
        print(f"Strawberry Cookies: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_cookie_problem()
