
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bean_production")

# Create variables
cocoa = m.addVar(name="cocoa")
coffee = m.addVar(name="coffee")

# Set objective function
m.setObjective(500 * cocoa + 750 * coffee, GRB.MAXIMIZE)

# Add constraints
m.addConstr(cocoa + coffee <= 15, "production_capacity")
m.addConstr(15 * cocoa + 15 * coffee <= 1000, "roasting_time")
m.addConstr(cocoa >= 3, "min_cocoa")
m.addConstr(coffee >= 5, "min_coffee")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Cocoa beans: {cocoa.x} tons")
    print(f"Coffee beans: {coffee.x} tons")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

