
from gurobipy import *

# Create a new model
m = Model("Factory_Optimization")

# Define variables
x1 = m.addVar(lb=3, name="cocoa_beans")  # Tons of cocoa beans
x2 = m.addVar(lb=5, name="coffee_beans")  # Tons of coffee beans

# Set the objective function
m.setObjective(500*x1 + 750*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 15, "production_capacity")
m.addConstr(15*x1 + 15*x2 <= 1000, "roasting_machine_availability")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cocoa beans: {x1.x} tons")
    print(f"Coffee beans: {x2.x} tons")
    print(f"Total profit: ${500*x1.x + 750*x2.x}")
else:
    print("No optimal solution found")
