
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=3, name="cocoa_beans")  # Minimum 3 tons of cocoa beans
    x2 = model.addVar(lb=5, name="coffee_beans")  # Minimum 5 tons of coffee beans

    # Objective function: Maximize 500*x1 + 750*x2
    model.setObjective(500*x1 + 750*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 15, name="production_capacity")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
