
import gurobipy as gp

# Create a new model
m = gp.Model("ball_throwing_game")

# Create variables
small_balls = m.addVar(vtype=gp.GRB.INTEGER, name="small_balls")
large_balls = m.addVar(vtype=gp.GRB.INTEGER, name="large_balls")

# Set objective function
m.setObjective(5 * small_balls + 2 * large_balls, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(small_balls + large_balls <= 20, "total_balls")
m.addConstr(small_balls >= 6, "min_small_balls")
m.addConstr(large_balls >= 5, "min_large_balls")
m.addConstr(small_balls <= 12, "max_small_balls")
m.addConstr(large_balls <= 12, "max_large_balls")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal score: {m.objVal}")
    print(f"Number of small balls to throw: {small_balls.x}")
    print(f"Number of large balls to throw: {large_balls.x}")
else:
    print("No solution found.")

