
from gurobipy import *

# Create a new model
m = Model("Ball_Throwing_Optimization")

# Define variables
x1 = m.addVar(name='small_balls', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='large_balls', vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(5*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 20, name='total_balls')
m.addConstr(x1 >= 6, name='min_small_balls')
m.addConstr(x2 >= 5, name='min_large_balls')
m.addConstr(x1 <= 12, name='max_small_balls')
m.addConstr(x2 <= 12, name='max_large_balls')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small balls: {x1.x}")
    print(f"Large balls: {x2.x}")
    print(f"Total score: {m.objVal}")
else:
    print("No optimal solution found")
